// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 ViewInv:ViewInverse;
   float4x4 ViewProj:ViewProjection;
   float4x4 View:View;

//-------------
// tweaks
//--------------
   float4 ViewSize1;
   float4 ViewSize2;
   float4 ViewProjInv1;
   float4 ViewProjInv2;
   float4 ViewProjInv3;
   float4 ViewProjInv4;
   float4 LightPosition[40];
   float4 LightMask[40];
   float3 LightAng1[40];
   float3 LightAng2[40];
   float3 LightAng3[40];
   float4 ShadowMask[40];

//--------------
// Textures
//--------------
   texture DepthTexture <string Name = " ";>;
   sampler DepthSampler=sampler_state 
      {
	Texture=<DepthTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
	MipFilter=None;
	MinFilter=None;
	MagFilter=None;
      };
   texture LightTexture <string Name = " ";>;
   sampler LightSampler=sampler_state 
      {
	Texture=<LightTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;	
      };
   texture ShadowMapTexture <string Name = " ";>;
   sampler ShadowMapSampler=sampler_state 
      {
	Texture=<ShadowMapTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
 	float2 Tex0:TEXCOORD0;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float4 Proj:TEXCOORD0;
 	float4 ClipSpace:TEXCOORD1;
 	float4 LightPos:TEXCOORD2;
 	float4 LightMask:TEXCOORD3;
	float3 Angle1:TEXCOORD4;
	float3 Angle2:TEXCOORD5;
	float3 Angle3:TEXCOORD6;
	float4 ShadowMask:COLOR0;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=mul(IN.Pos,WorldVP); 
        OUT.Proj=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z,OUT.Pos.w);
        OUT.ClipSpace=float4(OUT.Pos.x,-OUT.Pos.y,OUT.Pos.z,OUT.Pos.w);
	int ArrayIdx=floor(IN.Tex0.x);
	OUT.LightPos=LightPosition[ArrayIdx];
	OUT.LightMask=LightMask[ArrayIdx];
	OUT.Angle1=LightAng1[ArrayIdx];
	OUT.Angle2=LightAng2[ArrayIdx];
	OUT.Angle3=LightAng3[ArrayIdx];
	OUT.ShadowMask=ShadowMask[ArrayIdx];
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
     {
	float4x4 ViewProjInv=float4x4(ViewProjInv1,ViewProjInv2,ViewProjInv3,ViewProjInv4);
	float Depth=tex2Dlod(DepthSampler,((IN.Proj/IN.Proj.w)*ViewSize2)+ViewSize1);
	float4 WorldPos=mul(float4(IN.ClipSpace.xy/IN.ClipSpace.w,Depth,1),ViewProjInv);
	float3 LightVec=IN.LightPos.xyz-(WorldPos.xyz/WorldPos.w);
	float Attenuation=length(LightVec);
	if(Attenuation>IN.LightPos.w) discard;
	float3 LightAngle=mul(LightVec,float3x3(IN.Angle1,IN.Angle2,IN.Angle3))/Attenuation;
	float2 Equirectangular=0.3183*float2(atan2(-LightAngle.z,LightAngle.x),acos(LightAngle.y));
	float PointImage=tex2Dlod(LightSampler,float4(Equirectangular.x*0.5+0.5,1.0-Equirectangular.y,0.0,0.0)).x;
	return IN.LightMask*PointImage;
     }

//--------------
// techniques   
//--------------
    technique PointLight
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS(); 
 	PixelShader  = compile ps_3_0 PS();
	AlphaBlendEnable=true;
	SrcBlend=one;
 	DestBlend=one;
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }